class GenerateCta {
	constructor(selector) {
		this.el = document.querySelector(selector);
		this.action = this.el.querySelector(".sunduk__action");
		this.order = this.el.querySelector(".sunduk__order");
		this.sunduk = this.el.querySelector(".sunduk__img");
		this.coin = this.el.querySelector(".sunduk__coin");
		this.btn = this.el.querySelector(".sunduk__btn");
		this.options = {};
		this.scrollTarget = null;
		this.scrollType = null;
	}

	handleEvent = () => {
		this.btn.classList.add("hidden");
		this.sunduk.setAttribute(
			"src",
			"https://amazing-cdn.com/scripts/nikita/chest/img/sunduk__gif.gif",
		);
		setTimeout(this.handleChestOpen, 1800);
	};

	handleChestOpen = () => {
		this.sunduk.setAttribute(
			"src",
			"https://amazing-cdn.com/scripts/nikita/chest/img/sunduk__open.png",
		);
		this.sunduk.classList.add("blur");
		this.coin.classList.remove("hidden");
		setTimeout(this.handleActionHidden, 2000);
	};

	handleActionHidden = () => {
		this.action.classList.add("hidden");
		this.order.classList.remove("hidden");
		this.scrollTarget.scrollIntoView({
			block: this.scrollType,
			behavior: "smooth",
		});
		this.validateInputs();
	};

	chest(options) {
		this.options = options;
		this.scrollTarget = this.el.querySelector(this.options.scroll.target);
		this.scrollType = this.options.scroll.type;
		this.btn.addEventListener("click", this.handleEvent);
		this.replaceData(options);
	}

	replaceData(data) {
		const prod = this.el.querySelector(".sunduk__prod");
		const productName = this.el.querySelectorAll(".sunduk__product");
		prod.setAttribute("src", data.img);
		productName.forEach((element) => {
			element.innerText = data.product;
		});
	}

	validateInputs = () => {
		const nameInput = this.el.querySelector(".sunduk__input[type='text']");
		const phoneInput = this.el.querySelector(".sunduk__input[type='tel']");

		const validateInput = (input, regex) => {
			input.value = input.value
				.split("")
				.filter((char) => regex.test(char))
				.join("");
		};

		// Валидация для имени (только буквы и пробелы)
		if (nameInput) {
			nameInput.addEventListener("input", () => {
				validateInput(nameInput, /^[A-Za-zА-Яа-яЁё\s]*$/);
			});
		}

		// Валидация для телефона (только цифры)
		if (phoneInput) {
			phoneInput.addEventListener("input", () => {
				validateInput(phoneInput, /^\+?\d*$/);
			});
		}
	};
}
